package org.rlcommunity.critter;

import org.rlcommunity.critter.Base.Vector2D;

/**
  * RayIntersection
  *
  * This class encapsulates intersection information between a Ray and
  *  a Polygon, most likely generated by a Scene object.
  *
  * @author Marc G. Bellemare
  */

public class RayIntersection
{
  public Polygon polygon;
  public Ray ray;
 
  /** The normal to the intersection on the polygon */ 
  public Vector2D normal;

  /** The point of intersection, in global coordinates */
  public Vector2D point; 

  /** The point of intersection, in Polygon coordinates */ 
  public double polyAlpha;

  /** The point of intersection, in ray coordinates (r = alpha * v + p) */ 
  public double rayAlpha;
}
